@echo off
setlocal

:: Variables
set CERT_NAME=Prinfotech
set CERT_PATH=%~dp0Prinfotech.cer

:: Function to check if a certificate exists in a store
call :CheckAndInstall "Root" "LocalMachine" %CERT_NAME% %CERT_PATH%
call :CheckAndInstall "TrustedPublisher" "LocalMachine" %CERT_NAME% %CERT_PATH%
call :CheckAndInstall "Root" "CurrentUser" %CERT_NAME% %CERT_PATH%
call :CheckAndInstall "TrustedPublisher" "CurrentUser" %CERT_NAME% %CERT_PATH%

echo Certificate installation process completed.
pause
exit /b

:CheckAndInstall
set STORE=%~1
set LOCATION=%~2
set NAME=%~3
set PATH=%~4

echo Checking if "%NAME%" is already installed in %LOCATION%\%STORE%...
certutil -store %LOCATION%\%STORE% | findstr /C:"%NAME%" > nul
if %errorlevel% equ 0 (
    echo Certificate "%NAME%" already exists in %LOCATION%\%STORE%.
) else (
    echo Adding certificate "%NAME%" to %LOCATION%\%STORE%...
    if "%LOCATION%"=="CurrentUser" (
        certutil -user -addstore %STORE% "%PATH%"
    ) else (
        certutil -addstore %STORE% "%PATH%"
    )
)
exit /b
